<?php 
	require_once 'SepaDirectDebit.php';
	
	$dt	= new DateTime();
	$ti = new DateInterval( "P8D" );		// + 8 Tage			
	$dt->add( $ti );	
	
	$sepaDD = new BlueStarSoftware\SEPA\SepaDirectDebit( array(
		'messageID'		=> time(),										
		'paymentID'		=> 'TRF-INVOICE-130904',				// Should be changed every time,
		'requestedCollectionDate'	=> $dt
	));
	
	$sepaDD->setCreditor( new BlueStarSoftware\SEPA\Creditor( array(
		'name'				=> 'My Company',              // Change to your name
		'iban'				=> 'DE68210501700012345678',	// Example. use your IBAN!
		'bic'					=> 'DEUTDEDB400',							// Example, use the BIC of your bank
		'identifier'	=> 'DE98ZZZ09999999999'				// Test Creditor / Test GläubigerID
	)) );
	
	$sepaDD->addDebtor( new BlueStarSoftware\SEPA\Debtor( array(
		'transferID'=>  'Invoice 130904-131',				// End2End-ID Will be shown to the customer 
		'mandateID'	=>  '37294',										//
		'mandateDateOfSignature'	=>  '2013-07-14',	// needed !
		'name'			=> 	'Max Mustermann', 
		'iban'			=>	'CH9300762011623852957',		// IBAN of the customer
		'bic'				=>	'GENODEF1P15',							// SWIFT/BIC of the customer bank 
		'amount'		=>	0.01, 											// value 
		'currency'	=>	'EUR', 	
		'info'			=>	'Info text. Invoice 130904-131'		
	)) );
	
  $sepaDD->addDebtor( new BlueStarSoftware\SEPA\Debtor( array(
    'transferID'=>  'Invoice 130904-132',        // End2End-ID Will be shown to the customer
    'mandateID' =>  '82517',                   //
    'mandateDateOfSignature'  =>  '2013-04-19',  // needed !
    'name'      =>   'John Doe',
    'iban'      => 'AD1200012030200359100100',   // IBAN of the customer
    'bic'       => 'SOLADEST600',              // SWIFT/BIC of the customer bank
    'amount'    => 0.02,                       // value
    'currency'  => 'EUR', 
    'info'      => 'Info text. Invoice 130904-133'  
  )) );		
	
	echo $sepaDD->toXML();
?>